//-------------------------------------------------------------------------
//
//          DELL INC. PROPRIETARY INFORMATION
//
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Dell Computer Corporation and may not
//  be copied or disclosed except in accordance with the terms of that
//  agreement.
//
//  Copyright (c) 1995-2008 Dell Inc. All Rights Reserved.
// 
//  Abstract/Purpose:
//	Common Utility functions
//
//  Environment:
//    Windows, Linux
//
//  Created/Version:
//    2008 Jan 10 / $Revision: $
//
//  Author:
//   Anima Agrawal
//
//  Last Modified By/On:
//    $Author: $ / $Date: $
//
//-------------------------------------------------------------------------



//global variables 

var MAX_FOUR_GROUP_LENGTH =4;
var MIN_FOUR_GROUP_LENGTH =1;
var NO_OF_FOUR_GROUPS =8;
var LOOPBACKADDRESS = "0000:0000:0000:0000:0000:0000:0000:0001";
var UNSPECIFIEDADDRESS = "0000:0000:0000:0000:0000:0000:0000:0000";
var ERROR_NOTPERMITTED=2;
var ERROR_INVALID_ADDRESS=5;
var LINKLOCAL_PREFIX="FE80";
var LEVEL_IPADDRESS = 1; // this is check the ip address from the remoteaccess 
var LEVEL_GENERAL = 2; // this is to check the other IPv6 address e.g. gateway
                       // DNS server, Pef destination

//This function checks if the IP addresss passed is IPv6 address or not
function IsIPv6(IPAddress)
{
	var IPAddressArray=IPAddress.split(":");
        //if there is no colon in the IPv6 address
        if (IPAddressArray.length>1)
         return true;
        else
        return false;    	  
    	
}

//===================================================================
//This functions add  the required number of zeros in a group
//and returns the concatnation of all the groups in the preferred form
//Assumption AddZero functions
//1) IPAddressArray is split on the basis of the ":"
//2) Input has valid IPv6 address characters
//3) IPAddressArray is not empty.
//=====================================================================*/

function AddZeros(IPAddressArray)
{
  var count=0;
  var IPAddress="";
  var len=IPAddressArray.length; // calculate the length of the array passed
  //iterate through the array and add the respective number of zeros in each group
  while(len>count)
  {
    var element="";
    var elementlen=IPAddressArray[count].length;
    if(count!=0)
              element+=":";
    if(elementlen<MAX_FOUR_GROUP_LENGTH)
    {
      switch(MAX_FOUR_GROUP_LENGTH-elementlen)
      {
        case 1: element+="0"; break;
        case 2: element+="00"; break;
        case 3: element+="000"; break;
      }
      
    }
    //concatenating the required number of zeros to each of the four digit group
    IPAddressArray[count]=element+IPAddressArray[count];      
    IPAddress+=IPAddressArray[count];     
    count++; 
  }//end while
  return IPAddress ;
}
//===================================================================
//This functions add  the required number of zeros in the IPv6 address
//and returns the IPv6 address in the preferred form
//Assumption ConvertToPreferred functions
//1) This function is called when there is double colon in the IPv6 address
//2) Input has valid IPv6 address characters
//3) firststring contains the string before double colon
//4) secondstring contains the string after the double colon
//5) It has valid number of the four digit group in the address
//=====================================================================

function ConvertToPreferred(firststring,len,secondstring,len1)
{
  
  var preferredIP="";
  var diff=NO_OF_FOUR_GROUPS-(len+len1);
  
  //split the firststring on the basis of colon and add the zeros
   if(firststring!="")   
   {	     
     IPDoubleSplitArray1=firststring.split(":");            
     firststring=AddZeros(IPDoubleSplitArray1);	   
   } //end if
   
   //split the second string on the basis of colon and the zeros
   if(secondstring!="")   
      {	     
        IPDoubleSplitArray2=secondstring.split(":");    
        secondstring=AddZeros(IPDoubleSplitArray2);	 
      }//end if
  
  //add the required number of the missing 4 digit zeros groups 
  //in the address
  
   if(len!=0)          
        preferredIP=firststring;
   else
        {
          preferredIP="0000";
          diff--;
        }
    switch(diff)
    {
      case 1: preferredIP+=":0000";break;
      case 2: preferredIP+=":0000:0000";break;
      case 3: preferredIP+=":0000:0000:0000";break;
      case 4: preferredIP+=":0000:0000:0000:0000";break;
      case 5: preferredIP+=":0000:0000:0000:0000:0000";break;
      case 6: preferredIP+=":0000:0000:0000:0000:0000:0000";break;
      case 7: preferredIP+=":0000:0000:0000:0000:0000:0000:0000";break;
    }  
  if(len1!=0)
    preferredIP+=":"+secondstring;
  return preferredIP;
}

//===================================================================
//This functions checks for the special addresses 
//Assumption Check_SpecialAddress functions
//1) Input is IPv6 address in preferred form
//=====================================================================

function Check_SpecialAddress(IPAddress)
{
  
  if(IPAddress==LOOPBACKADDRESS)
    return ERROR_NOTPERMITTED;
  if(IPAddress==UNSPECIFIEDADDRESS)
    return ERROR_NOTPERMITTED;;
  return true;
}
//===================================================================
//This functions checks the length of the each group seperated by colon
//Assumption for the function Check_Octate 
//1) Input IPAddressArray has the valid IPv6 characters and required number 
// of four digit groups
//=====================================================================

function Check_Octate(IPAddressArray,length)
{
  var count=0;
  while(length>count)
  {
    var elementlen=IPAddressArray[count].length;
    //length of each group should be between 4 and 1. Both inclusive
    if(elementlen>MAX_FOUR_GROUP_LENGTH || elementlen<MIN_FOUR_GROUP_LENGTH)
     return false;
     count++;
  }
  return true;
}
//===================================================================
//This functions checks the input prefix depending upon the level 
// passed 
//Assumption for the function Check_Prefix 
//1) Input prefix is the first four digit group
//2) Prefix has valid IPv6 characters 
//=====================================================================

function Check_Prefix(prefix,level)
{
    if(prefix=="")
      return true;  
    var upperprefix=prefix.toUpperCase();
     if( level ==LEVEL_IPADDRESS)
      if(upperprefix=="FE80")
          return ERROR_NOTPERMITTED; // link-local are not permitted
             
     if(upperprefix.charAt(0)=='F')
    	if(upperprefix.charAt(1)=='F')
       		return ERROR_NOTPERMITTED;//multicast is not permitted
    return true;
}
//==========================================================================
//Assumption - for the validation of Ipv6 alogrithm
//1) Mixed mode addrsses are not permitted
//2) Zone indices are not considered
//3) base notation addresses are not permitted
//4) This checks for the basic format of the IPv6 address
//5) level 1 - IPaddress - mulitcast, loopback and link-local are not permitted
//6) level 2 - Pef destination, gateway, DNS address 
//7) Mulitcast and loopback addresses are not permitted
//8) Special addresses - "::" is not permitted 
//9) Input str contains the IPv6 address
//10) Input level can take two values LEVEL_IPADDRESS and LEVEL_GENERAL
//============================================================================

function Valid_IPv6(str,level)
{
  //alert(str);
  var IPDoubleSplitArray,IPDoubleSplitArray1,prefix="";
  var doublelength,doublelength1;
  var IPAddressPreferred;

   if(str == "" || str.length == 0)
 	return ERROR_INVALID_ADDRESS;     
   
   var pattern=new RegExp("[^0-9,A-F,a-f,:]");
   if(pattern.test(str)==true)
        return ERROR_INVALID_ADDRESS; // invalid character found in the string
        
 // check for double colon
   var IPAddressArray=str.split("::");
   //if there is no colon in the IPv6 address
   if (IPAddressArray.length==1)
    {           
      //split on colon 
      var  IPColonArray=str.split(":");
      if(IPColonArray.length!=NO_OF_FOUR_GROUPS)
          return ERROR_INVALID_ADDRESS; // invalid number of four digit groups in the address 
	
      // check if total number of characters each group is between [4,1]
      if(!Check_Octate(IPColonArray,IPColonArray.length))
         return ERROR_INVALID_ADDRESS;
      // convert the address into preferred form
        IPAddressPreferred=AddZeros(IPColonArray);
        prefix=IPColonArray[0];		
 } //end if
else 
{
   // if there are more than one double colon in the IPv6 Address.
   if (IPAddressArray.length>2)
      return ERROR_INVALID_ADDRESS;
   
   // split the array1 received on the basis of colon.
   
   //after splitting on double colon if the first element is empty e.g. ::2 first element will empty
   if(IPAddressArray[0]=="")
      doublelength=0;
   else
   	{	     
   	  IPDoubleSplitArray1=IPAddressArray[0].split(":");    
   	  doublelength=IPDoubleSplitArray1.length;         
   	  // check if the number of character in each group is in the range[4,1]
   	  if(!Check_Octate(IPDoubleSplitArray1,doublelength))
		 return ERROR_INVALID_ADDRESS;
   	   else
   	    	prefix=IPDoubleSplitArray1[0];	      
    }
        //split array2 on the basis of colon
        
      //after splitting on double colon if the second element is empty e.g. 2:: second element will be empty
	if(IPAddressArray[1]=="")
	    doublelength1=0;
	 else
	    {
	        IPDoubleSplitArray2=IPAddressArray[1].split(":");                                	        
	        doublelength1=IPDoubleSplitArray2.length;	       
	        
	        // check if the number of character in each group is in the range[4,1]
	        if(!Check_Octate(IPDoubleSplitArray2,doublelength1))
	       		return ERROR_INVALID_ADDRESS;        	   
	     }       
	 // check if the number of groups in the IPv6 address should be less that 8
	 if(doublelength+doublelength1 >=NO_OF_FOUR_GROUPS)	     
	     return ERROR_INVALID_ADDRESS;
	 //convert to preferred form
	 IPAddressPreferred=ConvertToPreferred(IPAddressArray[0],doublelength,IPAddressArray[1],doublelength1);
	  
    } //end double colon        
    
    // check for the spcial address not permitted 
    var error=Check_SpecialAddress(IPAddressPreferred);
    if(error!=true)
	return error;
   
   //check for the special range if addres not permitted 
    error=Check_Prefix(prefix,level);
    
    if(error!=true)
       return error;
    return true;
    
 } //end of funtion
  