﻿var ClarityJSVersion = "1.26";
var addEvent = {
  add: function (obj, evType, fn, useCapture) {
    // cross-browser event handling for IE5+, NS6 and Mozilla
    // By Scott Andrew
    if (obj.addEventListener) {
      obj.addEventListener(evType, fn, useCapture);
      return true;
    } else if (obj.attachEvent) {
      var r = obj.attachEvent("on" + evType, fn);
      return r;
    } else {
      alert("Handler could not be attached");
    }
  },
  remove: function (obj, evType, fn, useCapture) {
    if (obj.removeEventListener) {
      obj.removeEventListener(evType, fn, useCapture);
      return true;
    } else if (obj.detachEvent) {
      var r = obj.detachEvent("on" + evType, fn);
      return r;
    } else {
      alert("Handler could not be removed");
    }

  }
};

/*
* Copyright (c) 2006 Jonathan Weiss <jw@innerewut.de>
*
* Permission to use, copy, modify, and distribute this software for any
* purpose with or without fee is hereby granted, provided that the above
* copyright notice and this permission notice appear in all copies.
*
* THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
* WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
* ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
* ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
* OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/


/* tooltip-0.2.js - Small tooltip library on top of Prototype 
* by Jonathan Weiss <jw@innerewut.de> distributed under the BSD license. 
*
* This tooltip library works in two modes. If it gets a valid DOM element 
* or DOM id as an argument it uses this element as the tooltip. This 
* element will be placed (and shown) near the mouse pointer when a trigger-
* element is moused-over.
* If it gets only a text as an argument instead of a DOM id or DOM element
* it will create a div with the classname 'tooltip' that holds the given text.
* This newly created div will be used as the tooltip. This is usefull if you 
* want to use tooltip.js to create popups out of title attributes.
* 
*
* Usage: 
*   <script src="/javascripts/prototype.js" type="text/javascript"></script>
*   <script src="/javascripts/tooltip.js" type="text/javascript"></script>
*   <script type="text/javascript">
*     // with valid DOM id
*     var my_tooltip = new Tooltip('id_of_trigger_element', 'id_of_tooltip_to_show_element')
*
*     // with text
*     var my_other_tooltip = new Tooltip('id_of_trigger_element', 'a nice description')
*
*     // create popups for each element with a title attribute
*    Event.observe(window,"load",function() {
*      $$("*").findAll(function(node){
*        return node.getAttribute('title');
*      }).each(function(node){
*        new Tooltip(node,node.title);
*        node.removeAttribute("title");
*      });
*    });
*    
*   </script>
* 
* Now whenever you trigger a mouseOver on the `trigger` element, the tooltip element will
* be shown. On o mouseOut the tooltip disappears. 
* 
* Example:
* 
*   <script src="/javascripts/prototype.js" type="text/javascript"></script>
*   <script src="/javascripts/scriptaculous.js" type="text/javascript"></script>
*   <script src="/javascripts/tooltip.js" type="text/javascript"></script>
*
*   <div id='tooltip' style="display:none; margin: 5px; background-color: red;">
*     Detail infos on product 1....<br />
*   </div>
*
*   <div id='product_1'>
*     This is product 1
*   </div>
*
*   <script type="text/javascript">
*     var my_tooltip = new Tooltip('product_1', 'tooltip')
*   </script>
*
* You can use my_tooltip.destroy() to remove the event observers and thereby the tooltip.
*/

var Tooltip = Class.create();
Tooltip.prototype = {
  initialize: function (element) {
    var options = Object.extend({
      default_css: false,
      margin: "0px",
      padding: "5px",
      backgroundColor: "#d6d6fc",
      min_distance_x: 10,
      min_distance_y: 10,
      delta_x: 0,
      delta_y: 0,
      zindex: 1000
    }, arguments[2] || {});

    this.element = $(element);

    this.options = options;

    var tooltext = this.element.getAttribute("tooltip");
    var inform = this.element.getAttribute("informational");
    if (tooltext != null && tooltext.length > 0) {
      this.createToolTip(tooltext);
    }
    if (inform != null && inform.length > 0) {
      this.createInformToolTip(inform);
    }


    // hide the tool-tip by default
    if(this.tool_tip!=null)
    this.tool_tip.hide();

    this.eventMouseOver = this.showTooltip.bindAsEventListener(this);
    this.eventMouseOut = this.hideTooltip.bindAsEventListener(this);
    this.eventMouseMove = this.moveTooltip.bindAsEventListener(this);

    this.registerEvents();

  },
  createToolTip: function (text) {
    this.tool_tip = $(document.createElement("div"));
    document.body.appendChild(this.tool_tip);
    this.tool_tip.addClassName("tooltip");
    this.tool_tip.appendChild(document.createTextNode(text));
  },
  createInformToolTip: function (text) {
    var div;
    var tarray = text.split('|');
    if (tarray.length > 1) {
      var inner = '<table id="informtip">'
    + '<tr><td class="informtitle">' + tarray[0] + '</td></tr>'
    + '<tr><td class="informbody">' + tarray[1] + '</td></tr></table>';
      this.tool_tip = $(document.createElement("div"));
      document.body.appendChild(this.tool_tip);
      this.tool_tip.addClassName("informtooltip");
      this.tool_tip.innerHTML = inner;
    }
    else {
      this.createToolTip(text);
    }
  },

  destroy: function () {
    Event.stopObserving(this.element, "mouseover", this.eventMouseOver);
    Event.stopObserving(this.element, "mouseout", this.eventMouseOut);
    Event.stopObserving(this.element, "mousemove", this.eventMouseMove);
  },

  registerEvents: function () {
    Event.observe(this.element, "mouseover", this.eventMouseOver);
    Event.observe(this.element, "mouseout", this.eventMouseOut);
    Event.observe(this.element, "mousemove", this.eventMouseMove);
  },

  moveTooltip: function (event) {
    Event.stop(event);
    // get Mouse position
    var mouse_x = Event.pointerX(event);
    var mouse_y = Event.pointerY(event);

    // decide if wee need to switch sides for the tooltip
    var dimensions = Element.getDimensions(this.tool_tip);
    var element_width = dimensions.width;
    var element_height = dimensions.height;

    if ((element_width + mouse_x) >= (this.getWindowWidth() - this.options.min_distance_x)) { // too big for X
      mouse_x = mouse_x - element_width;
      // apply min_distance to make sure that the mouse is not on the tool-tip
      mouse_x = mouse_x - this.options.min_distance_x;
    } else {
      mouse_x = mouse_x + this.options.min_distance_x;
    }

    if ((element_height + mouse_y) >= (this.getWindowHeight() - this.options.min_distance_y)) { // too big for Y
      mouse_y = mouse_y - element_height;
      // apply min_distance to make sure that the mouse is not on the tool-tip
      mouse_y = mouse_y - this.options.min_distance_y;
    } else {
      mouse_y = mouse_y + this.options.min_distance_y;
    }

    // now set the right styles
    this.setStyles(mouse_x, mouse_y);
  },


  showTooltip: function (event) {
    Event.stop(event);
    this.moveTooltip(event);
    this.id = Element.show.delay(0.5, this.tool_tip);
  },

  setStyles: function (x, y) {
    // set the right styles to position the tool tip
    Element.setStyle(this.tool_tip, { position: 'absolute',
      top: y + this.options.delta_y + "px",
      left: x + this.options.delta_x + "px",
      zindex: this.options.zindex
    });

    // apply default theme if wanted
    if (this.options.default_css) {
      Element.setStyle(this.tool_tip, { margin: this.options.margin,
        padding: this.options.padding,
        backgroundColor: this.options.backgroundColor,
        zindex: this.options.zindex
      });
    }
  },

  hideTooltip: function (event) {
    window.clearTimeout(this.id);
    Element.hide(this.tool_tip);
  },

  getWindowHeight: function () {
    var innerHeight;
    if (navigator.appVersion.indexOf('MSIE') > 0) {
      innerHeight = document.body.clientHeight;
    } else {
      innerHeight = window.innerHeight;
    }
    return innerHeight;
  },

  getWindowWidth: function () {
    var innerWidth;
    if (navigator.appVersion.indexOf('MSIE') > 0) {
      innerWidth = document.body.clientWidth;
    } else {
      innerWidth = window.innerWidth;
    }
    return innerWidth;
  }

}

var tooltips = {
  initialize: function () {

    var ti;
    if (!document.links) {
      document.links = document.getElementsByTagName("a");
    }
    for (ti = 0; ti < document.links.length; ti++) {
      var lnk = document.links[ti];
      if (lnk.className == "informational") {
        lnk.setAttribute("informational", lnk.title);
        new Tooltip(lnk);
        lnk.removeAttribute("title");
      }
      else {
        if (lnk.title) {
          lnk.setAttribute("tooltip", lnk.title);
          new Tooltip(lnk);
          lnk.removeAttribute("title");

        }

      }
    }
    if (!document.images) {
      document.images = document.getElementsByTagName("img");
    }
    for (ti = 0; ti < document.images.length; ti++) {
      var img = document.images[ti];
      if (img.title || img.alt) {
        img.setAttribute("tooltip", img.alt);
        img.setAttribute("tooltip", img.title);
        new Tooltip(img);
        img.removeAttribute("alt");
        img.removeAttribute("title");
      }
    }
  }
};

var tableSort = {
  startSort: function (obj, id, col, rev) {
    this.sortStarted = true;
    obj.blur();
    obj.style.cursor = "wait";
    window.document.body.style.cursor = "wait";
    this.sortTable(id, col, rev);
    this.timer = setInterval(function () { tableSort.checkProgress(obj) }, 500);
    return this.sortStarted;
  },
  checkProgress: function (obj) {
    if (!this.sortStarted) {
      obj.style.cursor = "";
      window.document.body.style.cursor = "default";
      clearInterval(this.timer);
    }
  },
  sortTable: function (id, col, rev) {

    // Style class names.
    this.rowClsNm = "fill";
    this.colClsNm = "topsorted";
    this.colClsNmDesc = "topsorteddescend";

    if (document.ELEMENT_NODE == null) {
      document.ELEMENT_NODE = 1;
      document.TEXT_NODE = 3;
    }
    // Get the table or table section to sort.
    var tblEl = document.getElementById(id);

    // The first time this function is called for a given table, set up an
    // array of reverse sort flags.
    if (tblEl.reverseSort == null) {
      tblEl.reverseSort = new Array();
      // Also, assume the date/time column is initially sorted.
      tblEl.lastColumn = 4;
    }

    // If this column has not been sorted before, set the initial sort direction.
    if (tblEl.reverseSort[col] == null)
    { tblEl.reverseSort[col] = rev; }

    // If this column was the last one sorted, reverse its sort direction.
    if (col == tblEl.lastColumn)
    { tblEl.reverseSort[col] = !tblEl.reverseSort[col]; }

    // Remember this column as the last one sorted.
    tblEl.lastColumn = col;

    // Set the table display style to "none" - necessary for Netscape 6 
    // browsers.
    var oldDsply = tblEl.style.display;
    tblEl.style.display = "none";

    // Sort the rows based on the content of the specified column using a
    // selection sort.

    var tmpEl;
    var i, j;
    var minVal, minIdx;
    var testVal;
    var cmp;

    for (i = 0; i < tblEl.rows.length - 1; i++) {

      // Assume the current row has the minimum value.
      minIdx = i;
      minVal = tableSort.__getTextValue(tblEl.rows[i].cells[col]);

      // Search the rows that follow the current one for a smaller value.
      for (j = i + 1; j < tblEl.rows.length; j++) {
        testVal = tableSort.__getTextValue(tblEl.rows[j].cells[col]);
        cmp = tableSort.__compareValues(minVal, testVal);
        // Negate the comparison result if the reverse sort flag is set.
        if (tblEl.reverseSort[col])
        { cmp = -cmp; }
        // Sort by the second column (team name) if those values are equal.
        if (cmp == 0 && col != 1) {
          cmp = tableSort.__compareValues(tableSort.__getTextValue(tblEl.rows[minIdx].cells[1]),
                            tableSort.__getTextValue(tblEl.rows[j].cells[1]));
        }
        // If this row has a smaller value than the current minimum, remember its
        // position and update the current minimum value.
        if (cmp > 0) {
          minIdx = j;
          minVal = testVal;
        }
      }

      // By now, we have the row with the smallest value. Remove it from the
      // table and insert it before the current row.
      if (minIdx > i) {
        tmpEl = tblEl.removeChild(tblEl.rows[minIdx]);
        tblEl.insertBefore(tmpEl, tblEl.rows[i]);
      }
    }

    // Make it look pretty.
    tableSort.__makePretty(tblEl, col, tblEl.reverseSort[col]);

    // Restore the table's display style.
    tblEl.style.display = oldDsply;

    this.sortStarted = false;

  },
  __normalizeString: function (s) {

    // Regular expressions for normalizing white space.
    var whtSpEnds = new RegExp("^\\s*|\\s*$", "g");
    var whtSpMult = new RegExp("\\s\\s+", "g");
    s = s.replace(whtSpMult, " ");  // Collapse any multiple whites space.
    s = s.replace(whtSpEnds, "");   // Remove leading or trailing white space.

    return s;
  },
  __getTextValue: function (el) {
    var i;
    var s;

    // Find and concatenate the values of all text nodes contained within the
    // element.
    s = "";
    for (i = 0; i < el.childNodes.length; i++) {
      if (el.childNodes[i].nodeType == document.TEXT_NODE)
      { s += el.childNodes[i].nodeValue; }
      else if (el.childNodes[i].nodeType == document.ELEMENT_NODE &&
             el.childNodes[i].tagName == "BR")
      { s += " "; }
      else
      // Use recursion to get text within sub-elements.
      { s += tableSort.__getTextValue(el.childNodes[i]); }
    }

    return tableSort.__normalizeString(s);
  },
  __compareValues: function (v1, v2) {
    var f1, f2;

    // If the values are numeric, convert them to floats.

    f1 = parseFloat(v1);
    f2 = parseFloat(v2);
    if (!isNaN(f1) && !isNaN(f2)) {
      v1 = f1;
      v2 = f2;
    }

    // Compare the two values.
    if (v1 == v2)
    { return 0; }
    if (v1 > v2)
    { return 1; }
    return -1;
  },
  __makePretty: function (tblEl, col, descendingsort) {
    // Regular expressions for setting class names.
    var rowTest = new RegExp(tableSort.rowClsNm, "gi");
    var colTest = new RegExp(tableSort.colClsNm, "gi");
    var colTestDescend = new RegExp(tableSort.colClsNmDesc, "gi");

    var i, j;
    var rowEl, cellEl;

    // Set style classes on each cell to alternate their appearance step the first and last cell in a row.
    for (i = 0; i < tblEl.rows.length; i++) {
      rowEl = tblEl.rows[i];
      rowEl.className = rowEl.className.replace(rowTest, "");
      if (i % 2 != 0)
      { rowEl.className += " " + tableSort.rowClsNm; }
      rowEl.className = tableSort.__normalizeString(rowEl.className);
      //This is if you put fill on each cell in the row.
      //            for (j = 1; j < rowEl.cells.length - 1; j++) {
      //              cellEl = rowEl.cells[j];
      //              cellEl.className = cellEl.className.replace(rowTest, "");
      //              if (i % 2 != 0)
      //              { cellEl.className += " " + tableSort.rowClsNm; }
      //              cellEl.className = tableSort.__normalizeString(cellEl.className);
      //            }
    }

    // Find the table header and highlight the column that was sorted.
    var el = tblEl.parentNode.tHead;
    rowEl = el.rows[0];
    // Set style classes for each column as above.
    for (i = 0; i < rowEl.cells.length; i++) {
      cellEl = rowEl.cells[i];
      cellEl.className = cellEl.className.replace(colTest, "");
      cellEl.className = cellEl.className.replace(colTestDescend, "");
      // Highlight the header of the sorted column.
      if (i == col) {
        if (descendingsort)
        { cellEl.className += " " + tableSort.colClsNmDesc; }
        else
        { cellEl.className += " " + tableSort.colClsNm; }
      }
      cellEl.className = tableSort.__normalizeString(cellEl.className);
    }
  }
};


var tableCopy = {
  /*
  Copies a selectbox, textbox or checkbox value located in the thead of a table
  to the tbody elements in the same column
  Usage:
  For a input type=checkbox - onclick="CopyAll(this);"
  For a select - onchange="CopyAll(this);"
  For a input type=text - onkeyup="CopyAll(this);" 
  */
  copyAll: function (obj) {
    //Get the cell number of the current item 
    var cellnum = obj.parentNode.cellIndex;
    //get the first tbody
    var tbody = obj.parentNode.offsetParent.tBodies[0];
    //Get the 
    var objtype = obj.type;
    var row, cell, cellitems, cellitem;
    for (var i = 0; i < tbody.rows.length; i++) {
      row = tbody.rows[i];
      cell = row.cells[cellnum];
      if (cell) {
        cellitems = cell.childNodes;
        for (var j = 0; j < cellitems.length; j++) {
          cellitem = cellitems[j];
          if (cellitem.type == objtype) {
            switch (objtype) {
              case "checkbox":
                cellitem.checked = obj.checked;
                break;
              case "select-one":
                cellitem.value = obj.value;
                break;
              case "text":
                cellitem.value = obj.value;
                break;
              default:
                break;
            }
          }

        }
      }
    }
  },
  /*
  This function resets the copyall controls located in the thead of the table
  Usage:
  For a input type=checkbox - onclick="ResetHeader(this);"
  For a select - onchange="ResetHeader(this);"
  For a input type=text - onkeyup="ResetHeader(this);" 
  */
  resetHeader: function (obj) {
    var cellnum = obj.parentNode.cellIndex;
    var thead = obj.parentNode.offsetParent.tHead;
    var objtype = obj.type;
    var row, cell, cellitems, cellitem;
    for (var i = 0; i < thead.rows.length; i++) {
      row = thead.rows[i];
      cell = row.cells[cellnum];
      if (cell) {
        cellitems = cell.childNodes;
        for (var j = 0; j < cellitems.length; j++) {
          cellitem = cellitems[j];
          if (cellitem.type == objtype) {
            switch (objtype) {
              case "checkbox":
                cellitem.checked = false;
                break;
              case "select-one":
                cellitem.selectedIndex = 0;
                break;
              case "text":
                cellitem.value = "";
                break;
              default:
                break;
            }
          }
        }
      }
    }
  }
};
//Script to highlight rows - REH
var tableHighlight = {
  highlightRow: function (e) {
    this.lasthoverclass = new Array();
    var tds = e.getElementsByTagName("td");
    var classname;
    for (var i = 0; i < tds.length; i++) {
      if (i == 0 || i == tds.length - 1)
      { continue; }
      classname = tds[i].className;

      this.lasthoverclass[i] = classname;
      tds[i].className = 'hover ' + classname;
    }
  },
  unHighlightRow: function (e) {
    var tds = e.getElementsByTagName("td");
    for (var i = 0; i < tds.length; i++) {
      if (i == 0 || i == tds.length - 1)
      { continue; }
      tds[i].className = tableHighlight.lasthoverclass[i];
    }
  }
};

var imageMap = {
  highlightedElement: null,
  loaded: false,
  selectedIndex: null,
  initialize: function () {
    if (!document.getElementById || !document.createElement || !document.getElementsByTagName)
    { return; }
    var anni = document.getElementsByTagName('img');
    for (var i = 0; i < anni.length; i++) {
      if ((anni[i].className.search(/\bannotated\b/) != -1) && (anni[i].getAttribute('usemap') != null)) {
        imageMap.prepImage(anni[i]);
        imageMap.loaded = true;
        if (imageMap.selectedIndex != null) {
          imageMap.select(this.selectedIndex);
        }
      }
    }
  },
  getHref: function (obj) {
    var rstring = null;
    var href = obj.getAttribute('href');
    if (href != null && href != "#") {
      if (href.search('javascript') == -1) {
        href = "javascript:document.location = '" + href + "';";
      }
      rstring = href;

    }
    return rstring;
  },
  getId: function (obj) {
    if (obj.id != null) {
      var id = obj.id;
      obj.id = null;
      return id;
    }
  },
  clearAttribs: function (obj) {
    obj.setAttribute('coords', '0,0,0,0');
    //obj.setAttribute('title', null);
    obj.setAttribute('href', '#');
    obj.setAttribute('onclick', null);
    obj.className = null;
  },
  select: function (index) {
    if (index != null) {
      if (!imageMap.loaded) {
        imageMap.selectedIndex = index;
      } else {
        imageMap.selectedIndex = null;
        var el = $(index);
        if (el != null) {
          imageMap.outlineElement(el);
        }
      }
    }
  },
  prepImage: function (img) {
    var mapName = img.getAttribute('usemap');
    if (mapName.substr(0, 1) == '#') { mapName = mapName.substr(1); }
    var mapObjs = document.getElementsByName(mapName);
    if (mapObjs.length != 1) { return; }
    var mapObj = mapObjs[0];
    var areas = mapObj.getElementsByTagName('area');
    img.areas = [];
    for (var j = areas.length - 1; j >= 0; j--) {
      if (areas[j].getAttribute('shape').toLowerCase() == 'rect') {
        var coo = areas[j].getAttribute('coords').split(',');
        var href = imageMap.getHref(areas[j]);
        var id = imageMap.getId(areas[j]);
        if (coo.length != 4) { break; }
        var thisAreaPosition = imageMap.__getAreaPosition(img, coo);
        var d = document.createElement('div');
        d.style.width = (parseInt(coo[2], 10) - parseInt(coo[0], 10)) + 'px';
        d.style.height = (parseInt(coo[3], 10) - parseInt(coo[1], 10)) + 'px';
        d.style.left = thisAreaPosition[0] + 'px';
        d.style.top = thisAreaPosition[1] + 'px';
        d.className = 'annotation';
        d.id = id;
        d.setAttribute('name', 'annotation');
        d.style.position = 'absolute';
        var showtip;
        if (areas[j].title != null) {
          showtip = true;
          if (areas[j].className == 'informational') {
            d.setAttribute('informational', areas[j].title);
          }
          else {
            d.setAttribute('tooltip', areas[j].title);
          }
        }
        imageMap.clearAttribs(areas[j]);
        d.setAttribute('href', href);
        document.getElementsByTagName('body')[0].appendChild(d);

        addEvent.add(d, "mouseover", imageMap.showArea);
        addEvent.add(d, "mouseout", imageMap.hideArea);
        addEvent.add(d, "click", imageMap.showOutline);

        if (showtip) {
          new Tooltip(d);
        }

      }
    }
  },

  __getAreaPosition: function (img, coo) {
    var aleft = (img.offsetLeft + parseInt(coo[0], 10));
    var atop = (img.offsetTop + parseInt(coo[1], 10));
    var oo = img;
    while (oo.offsetParent) {
      oo = oo.offsetParent;
      aleft += oo.offsetLeft;
      atop += oo.offsetTop;
    }
    return [aleft, atop];
  },
  showArea: function (e) {
    var el = imageMap.__getElement(e);
    if (el == imageMap.highlightedElement) {
      imageMap.removeClass(el, 'showoutline');
    }
    imageMap.addClass(el, 'highlight');
  },
  hideArea: function (e) {
    var el = imageMap.__getElement(e);
    if (el == imageMap.highlightedElement) {
      imageMap.addClass(el, 'showoutline');
    }
    imageMap.removeClass(el, 'highlight');
  },
  showOutline: function (e) {
    var el = imageMap.__getElement(e);
    imageMap.outlineElement(el);
  },
  outlineElement: function (el) {
    if (imageMap.highlightedElement) {
      imageMap.removeOutline();
    }
    //Excute the href code
    var href = el.getAttribute('href');
    if (href != null) {
      eval(href);
    }
    imageMap.removeClass(el, 'highlight');
    imageMap.addClass(el, 'showoutline');
    imageMap.highlightedElement = el;
  },
  removeOutline: function () {
    var highlight = imageMap.highlightedElement;
    if (highlight) {
      imageMap.removeClass(highlight, 'showoutline');
      imageMap.highlightedElement = null;
    }
  },
  __getElement: function (e) {
    var t = null;
    if (e && e.target) { t = e.target; }
    if (window.event && window.event.srcElement) { t = window.event.srcElement; }
    return t;
  },
  showAll: function () {
    var divs = document.getElementsByTagName('div');
    for (i = 0; i < divs.length; i++) {
      if (divs[i].getAttribute('name') == 'annotation') {
        divs[i].style.display = 'block';
      }
    }
  },
  hideAll: function () {
    var divs = document.getElementsByTagName('div');
    for (i = 0; i < divs.length; i++) {
      if (divs[i].getAttribute('name') == 'annotation') {
        divs[i].style.display = 'none';
      }
    }
  },
  addClass: function (el, cls) {
    if (!el.className.match(new RegExp('(^| )' + cls + '($| )'))) {
      el.className += ' ' + cls;
      el.className = el.className.replace(/(^ +)|( +$)/g, '');
    }
  },
  removeClass: function (el, cls) {
    var old = el.className;
    var newCls = ' ' + el.className + ' ';
    newCls = newCls.replace(new RegExp(' (' + cls + ' +)+', 'g'), ' ');
    el.className = newCls.replace(/(^ +)|( +$)/g, '');
  }
};

var pullTab = {
  Debug: false,
  ra_resizeStart: function (e, splitter) {
    this.dragging = true;
    this.rightSectionMinWidth = 200;
    this.ra_splitter = splitter;
    splitter.parrentOffsetX = pullTab.ra_GetX(splitter.parentNode) + e.clientX - pullTab.ra_GetX(splitter);
    document.onmousemove = function (e) { if (!e) { e = window.event; } pullTab.ra_mouseMove(e); };
    document.onmouseup = function (e) { if (!e) { e = window.event; } pullTab.ra_resizeStop(e); };
    document.body.ondrag = function () { return !pullTab.dragging; };
    return false;
  },
  ra_GetX: function (oElement) {
    var x = 0;
    while (oElement != null) {
      x += oElement.offsetLeft;
      oElement = oElement.offsetParent;
    }
    return x;
  },
  ra_mouseMove: function (e) {
    var splitter = this.ra_splitter;
    x = e.clientX - splitter.parrentOffsetX;
    if (x >= splitter.parentNode.offsetWidth - splitter.offsetWidth - pullTab.rightSectionMinWidth) {
      x = splitter.parentNode.offsetWidth - splitter.offsetWidth - pullTab.rightSectionMinWidth;
    }
    splitter.style.left = x + "px";
    return false;
  },
  ra_resizeStop: function () {
    document.onmousemove = null;
    document.onmouseup = null;
    var frameset = parent.document.getElementById("contentframeset");
    var splitter = this.ra_splitter;
    var cols = frameset.cols.split(',');
    cols[0] = parseInt(cols[0], 10);
    cols[0] += splitter.offsetLeft;
    cols[1] = '*';
    splitter.style.left = '0px';
    frameset.cols = cols.join(',');
    pullTab.dragging = false;
    //clear the document selection
    if (document.selection) { document.selection.empty(); }
    else if (window.getSelection)
    { window.getSelection().removeAllRanges(); }
  },
  changePullTab: function () {
    try {
      var viewwidth = document.documentElement.clientWidth;
      var viewheight = document.documentElement.clientHeight;
      var scrollwidth = document.body.scrollWidth ? document.body.scrollWidth : document.documentElement.offsetWidth;
      var scrollheight = document.body.scrollHeight ? document.body.scrollHeight : document.documentElement.offsetHeight;
      var scrolltop = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
      var scrollleft = document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;

      var viewportwidth = scrollwidth > viewwidth ? scrollwidth : viewwidth;
      var viewportheight = scrollheight > viewheight ? scrollheight : viewheight;

	  var toolbar_td = document.getElementById('toolbar_td');
		if(toolbar_td)
		{
			var pagetitle_td = document.getElementById('pagetitle_td');
			if(pagetitle_td)
			{
				pagetitle_td.width = (viewwidth - toolbar_td.clientWidth) + 'px';
			}
		}
	  
      var rightside = document.getElementById('rightside');
      if (rightside) {
        if (scrollheight > viewheight) {
          rightside.style.display = "none";
        }else if(scrollleft > 0)
		{
			//page has been scrolled right. remove rightside border
			rightside.style.display = "none";
		}
        else {
          rightside.style.display = "block";
          rightside.style.height = viewportheight + 'px';
          rightside.style.right = scrollleft * -1 + 'px';
        }
      }
      var pullstrip = document.getElementById('pullstrip');
      if (pullstrip) {
        pullstrip.style.height = viewportheight + 'px';
        pullstrip.style.left = scrollleft + 'px';
      }

      //    var pulltab = document.getElementById('pulltab');
      //    if (pulltab) {
      //      var pos = 0;
      //      if (scrollheight > viewheight) {
      //        pos = scrollheight - viewheight - scrolltop + 42;
      //      } else {
      //        pos = 42;
      //      }
      //      pulltab.style.bottom = pos + 'px';
      //      pulltab.style.left = '5px';
      //    }
    }
    catch (e) { }
  }
};

var popUp = {
  initialize: function () {
    popUp.setHeight();
    addEvent.add(window, "scroll", function () { popUp.setHeight(); });
    addEvent.add(window, "resize", function () { popUp.setHeight(); });
  },
  setHeight: function () {
    var viewheight = document.documentElement.clientHeight;
    var popupoverflow = document.getElementById('popup_overflow');
    if (popupoverflow) {
      var offset = popUp.findPos(popupoverflow)[1];
      popupoverflow.style.height = viewheight - offset + 'px';
    }
  },
  findPos: function (obj) {
    var curleft = curtop = 0;
    if (obj.offsetParent) {
      do {
        curleft += obj.offsetLeft;
        curtop += obj.offsetTop;
      } while (obj = obj.offsetParent);
      return [curleft, curtop];
    }
  },
  openWindow: function (url, windowtitle, popwidth, popheight) {
    if (windowtitle == null) {
      var windowtitle = 'popup';
    }
    if (popwidth == null) {
      popwidth = 700;
    }
    if (popheight == null) {
      popheight = 400;
    }
    if (url != null) {
      window.open(url, windowtitle, 'width=' + popwidth + ',height=' + popheight + ',toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,copyhistory=no,resizable=yes');
    }
  },
  closeWindow: function () {
    window.close();
  },
  scrolltoTop: function () {
    var popupoverflow = document.getElementById('popup_overflow');
    if (popupoverflow) { popupoverflow.scrollTop = 0; }
  }
};
var transferBox = {
  selectItem: function (obj) {
    if (obj.className != "unavaliable") {
      if (obj == this.LAST_SELECTED) {
        obj.className = "avaliable"
        this.LAST_SELECTED = null;
      }
      else {
        if (this.LAST_SELECTED) {
          this.LAST_SELECTED.className = "avaliable";
        }
        obj.className = "selected";
        obj.style.width = obj.offsetWidth;
        this.LAST_SELECTED = obj;
      }
    }
  },
  addItem: function () {
    var item = $('avaliable_box').select('[class="selected"]')[0];
    if (item != null) {
      //Get the id of the selection
      var idselected = this.__selectAndRemove(item);
      //Mark the item unavaliable
      item.className = 'unavaliable';
      //Clear the selected list
      var selectedlist = $('selected_box').select('div');
      for (var i = 0; i < selectedlist.length; i++) {
        selectedlist[i].remove();
      }
      //Get all the items marked as unavaliable and copy them back into the selected list
      //This keeps them in order.
      this.__copyToSelectedBox();

      //This method just adds it to the bottom of the list and does maintain order.
      //Create div id to put in the selected collection
      //var el = new Element('div', { 'class': 'avaliable', 'id': 's-' + idselected }).update(item.innerHTML);
      //$('selected_box').appendChild(el);
      //this.__addEvents(el);

    }
  },

  removeItem: function () {
    var item = $('selected_box').select('[class="selected"]')[0];
    if (item != null) {
      //Get the id of the selection
      var idselected = this.__selectAndRemove(item);

      //remove the div
      item.remove();
      //get the div from the avaliable side and change it's class to avaliable
      var avbox = $('avaliable_box').select('[class="unavaliable"]');
      var ai, aiid;
      for (var i = 0; i < avbox.length; i++) {
        ai = avbox[i];
        aiid = ai.id.split('-')[1];
        if (aiid == idselected) {
          ai.className = 'avaliable';
        }
      }

    }

  },
  buildLists: function () {
    this.__buildList('avaliable_box', 'avaliable');
    this.__buildList('selected_box', 'selected');
    this.__reportAvaliable();
    this.__reportSelected();
  },
  __buildList: function (listbox, listobj) {
    var list = $(listbox).select('[class="avaliable"]');
    var newArray = Array();
    var itemid;
    for (var i = 0; i < list.length; i++) {
      itemid = list[i].id.split('-')[1];
      newArray.push(itemid);
    }
    $(listobj).value = newArray.join(',');
  },
  setupEvents: function () {
    this.__setupDivs($('avaliable_box').select('div'));
    this.__setupDivs($('selected_box').select('div'));
  },
  __addEvents: function (obj) {
    obj.observe('mouseover', function () { this.style.cursor = "pointer"; });
    obj.observe('mouseout', function () { this.style.cursor = "default"; });
    obj.observe('click', function () { transferBox.selectItem(this) });
  },
  __setupDivs: function (obj) {
    for (var i = 0; i < obj.length; i++) {
      this.__addEvents(obj[i]);
    }
  },
  __selectAndRemove: function (item) {
    //Change last selected to null so item does no high light
    this.LAST_SELECTED = null;
    return item.id.split('-')[1];
  },
  __copyToSelectedBox: function () {
    //Get unavaliable items
    selectedlist = $('avaliable_box').select('[class="unavaliable"]');
    //Get the selected_box div to append elements
    var selectbox = $('selected_box');
    var selectitem, aid;
    for (var i = 0; i < selectedlist.length; i++) {
      //Clone the item
      selectitem = selectedlist[i].cloneNode(true);
      //Change it's css name
      selectitem.className = "avaliable";
      //Change the id
      aid = selectitem.id.split('-')[1];
      selectitem.id = 's-' + aid;
      //Append it to the selected_box div
      selectbox.appendChild(selectitem);
      //Add Events to the item
      this.__addEvents(selectitem);
    }
  },
  //These are just helper functions to use to test when form is submitted.
  __reportAvaliable: function () {
    alert($F('avaliable'));
  },
  __reportSelected: function () {
    alert($F('selected'));
  }

};

var pageTitle = {
  setTitle: function (titleoverride) {
    if (titleoverride != null) {
      parent.document.title = titleoverride;
    } else if (document.getElementById("pageTitle") != null) {
      var datitle = document.getElementById("pageTitle").innerHTML;
      parent.document.title = this.__getSystemTitle(datitle);
    }
  },
  __getSystemTitle: function (datitle) {
    //Not sure how to do this in firefox.
    try {
      var systemName = parent.title.document.getElementById("system_name");
      //var systemName = parent.document.frames[2].document.getElementById("system_name");
      //May need to change this based on how the systemName is produced.
      if (systemName != null) {
        if (document.all) {
          return systemName.innerText + " : " + datitle;
        } else {
          return systemName.childNodes[2].nodeValue + " : " + datitle;
        }
      }
    }
    catch (err) {
      return datitle;
    }
  }

};

//This is for the Progress Bar
var progressBar = {
  timeout: null,
  show: function (now) {
    if (now == true) {
      progressBar.display();
    }
    else {
      progressBar.timeout = setTimeout(progressBar.display, 3000);
    }
  },
  display: function () {
    var modalpage = document.getElementById('progressPage');
    var modalgraphic = document.getElementById('progressGraphic');
    if (modalpage != null && modalgraphic != null) {
      modalgraphic.style.top = progressBar.calculatepos();
      modalpage.style.display = "block";
      addEvent.add(window, "scroll", progressBar.setModalGraphic);
      addEvent.add(window, "resize", progressBar.setModalGraphic);
    }
  },
  hide: function () {
    var modalpage = document.getElementById('progressPage');
    if (modalpage != null) {
      modalpage.style.display = "none";
      addEvent.remove(window, "scroll", progressBar.setModalGraphic);
      addEvent.remove(window, "resize", progressBar.setModalGraphic);
      clearTimeout(progressBar.timeout);
    }
  },
  calculatepos: function () {
    var pos = 0;
    try {
      var viewheight = document.documentElement.clientHeight;
      var scrollheight = document.body.scrollHeight ? document.body.scrollHeight : document.documentElement.offsetHeight;
      var scrolltop = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
      var viewportheight = scrollheight > viewheight ? scrollheight : viewheight;

      if (scrollheight > viewheight) {
        pos = viewheight * .5 - 100 + scrolltop + 'px';
      } else {
        pos = viewheight * .5 - 100 + 'px';
      }
    }
    catch (err) { }
    return pos;
  },
  setModalGraphic: function () {
    var modalgraphic = document.getElementById('progressGraphic');
    if (modalgraphic != null) {
      modalgraphic.style.top = progressBar.calculatepos();
    }
  }
};
var finiteProgressBar = {
  show: function () {
    var modalpage = document.getElementById('finiteprogressPage');
    var modalgraphic = document.getElementById('finiteprogressGraphic');
    if (modalpage != null && modalgraphic != null) {
      modalgraphic.style.top = finiteProgressBar.calculatepos();
      modalpage.style.display = "block";
      addEvent.add(window, "scroll", finiteProgressBar.setModalGraphic);
      addEvent.add(window, "resize", finiteProgressBar.setModalGraphic);
    }
  },
  hide: function () {
    var modalpage = document.getElementById('finiteprogressPage');
    if (modalpage != null) {
      modalpage.style.display = "none";
      addEvent.remove(window, "scroll", finiteProgressBar.setModalGraphic);
      addEvent.remove(window, "resize", finiteProgressBar.setModalGraphic);
    }
  },
  calculatepos: function () {
    var pos = 0;
    try {
      var viewheight = document.documentElement.clientHeight;
      var scrollheight = document.body.scrollHeight ? document.body.scrollHeight : document.documentElement.offsetHeight;
      var scrolltop = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
      var viewportheight = scrollheight > viewheight ? scrollheight : viewheight;

      if (scrollheight > viewheight) {
        //pos = scrolltop;
        pos = viewheight * .5 - 66 + scrolltop + 'px';
      } else {
        pos = viewheight * .5 - 66 + 'px';
      }
    }
    catch (err) { }
    return pos;
  },
  setModalGraphic: function () {
    var modalgraphic = document.getElementById('finiteprogressGraphic');
    if (modalgraphic != null) {
      modalgraphic.style.top = finiteProgressBar.calculatepos();
    }
  },
  setProgress: function (percent_complete) {
    var progressbar = document.getElementById('finiteProgressBar');
    if (progressbar != null) {
      if (percent_complete <= 100) {
        progressbar.style.width = percent_complete + '%';
      }
    }
  }
};
//Need to refactor the progress and modal stuff using more prototype framework.
var modalError = {
  show: function () {
    var modalpage = $('modalDiv');
    var modalgraphic = $('error_modal');
    var viewport = document.viewport.getDimensions();
    if (modalpage != null && modalgraphic != null) {
      modalpage.style.display = "block";
      //modalpage.setStyle({ width: viewport.width + 'px', height: viewport.height + 'px' });
      //modalpage.select('div.modalBackground').first().setStyle({ width: viewport.width + 'px', height: viewport.height + 'px' });
      //need to set the width and height of the clientwindow here.
      //research for later.
      modalgraphic.style.top = modalError.calculatepos();
      addEvent.add(window, "scroll", modalError.setModalGraphic);
      addEvent.add(window, "resize", modalError.setModalGraphic);
    }
  },
  hide: function () {
    var modalpage = $('modalDiv');
    if (modalpage != null) {
      modalpage.style.display = "none";
      addEvent.remove(window, "scroll", modalError.setModalGraphic);
      addEvent.remove(window, "resize", modalError.setModalGraphic);
    }
  },
  calculatepos: function () {
    var pos = 0;
    try {
      var viewheight = document.documentElement.clientHeight;
      var scrollheight = document.body.scrollHeight ? document.body.scrollHeight : document.documentElement.offsetHeight;
      var scrolltop = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
      var viewportheight = scrollheight > viewheight ? scrollheight : viewheight;

      if (scrollheight > viewheight) {
        //pos = scrolltop;
        pos = (viewheight * .5) - ($('error_modal').getHeight() / 2) + scrolltop + 'px';
      } else {
        pos = (viewheight * .5) - ($('error_modal').getHeight() / 2) + 'px';
      }
    }
    catch (err) { }
    return pos;
  },
  setModalGraphic: function () {
    var modalgraphic = $('error_modal');
    if (modalgraphic != null) {
      modalgraphic.style.top = modalError.calculatepos();
    }
  }
};
var containerTree = {
  toggle: function (el) {
    if (!el.className.match(/(^| )closed($| )/)) {
      this.treeClose(el)
    } else {
      this.treeOpen(el)
    }
  },
  treeClose: function (el) {
    this.addClass(el, "closed");
    this.removeClass(el, "opened");
    var div = el.offsetParent.getElementsByTagName('div');
    div[0].style.display = "none";
  },
  treeOpen: function (el) {
    this.addClass(el, "opened");
    this.removeClass(el, "closed");
    var div = el.offsetParent.getElementsByTagName('div');
    div[0].style.display = "block";
    div[0].style.offsetHeight = 0;
  },
  addClass: function (el, cls) {
    if (!el.className.match(new RegExp('(^| )' + cls + '($| )'))) {
      el.className += ' ' + cls;
      el.className = el.className.replace(/(^ +)|( +$)/g, '');
    }
  },
  removeClass: function (el, cls) {
    var old = el.className;
    var newCls = ' ' + el.className + ' ';
    newCls = newCls.replace(new RegExp(' (' + cls + ' +)+', 'g'), ' ');
    el.className = newCls.replace(/(^ +)|( +$)/g, '');
  }
};
var docOverFlow = {
  initialize: function () {
    if (parent.snb) {
      docOverFlow.__getDivs();
      docOverFlow.checkSize();
      setTimeout(function () { docOverFlow.__setPos(); }, 300);
      docOverFlow.__setEvents();
    }
  },
  scrollable: false,
  checkSize: function () {
    var snbtable = parent.snb.document.getElementById("snbtable");
    var lsnbtable = parent.lsnb.document.getElementById("lsnbtable");
    var tempobj = docOverFlow.__getMax(snbtable, lsnbtable);
    if (tempobj) {
      var y = document.getElementById("dataarea");
      docOverFlow.__reset();
      if (tempobj.offsetWidth > document.documentElement.clientWidth) {
        if (y) {
          y.style.width = parseInt(tempobj.offsetWidth) + 'px';
          docOverFlow.scrollable = true;
        }
      } else {
        if (y) {
          y.style.width = 'auto';
          docOverFlow.scrollable = false;
        }
      }
    };
  },
  scroll: function () {
    if (docOverFlow.scrollable) {
      docOverFlow.__setLeft(docOverFlow.snbtabs);
      docOverFlow.__setLeft(docOverFlow.lsnbtabs)
      docOverFlow.__setRight(docOverFlow.snbright);
      docOverFlow.__setRight(docOverFlow.lsnbright);
    }
  },
  __reset: function () {
    try {
      docOverFlow.__resetLeftStyle(docOverFlow.snbtabs);
      docOverFlow.__resetLeftStyle(docOverFlow.lsnbtabs);
      docOverFlow.__resetRightStyle(docOverFlow.snbright);
      docOverFlow.__resetRightStyle(docOverFlow.lsnbright);
    }
    catch (err) { }
  },
  __resetLeftStyle: function (el) {
    if (el) {
      el.style.left = '0px';
    }
  },
  __resetRightStyle: function (el) {
    if (el) {
      el.style.right = '0px';
    }
  },
  __setPos: function () {
    if (docOverFlow.snbtabs) {
      //var x = parseInt(docOverFlow.snbtabs.style.left) * -1;
      if (docOverFlow.scrollable) {
        //parent.da.window.scrollTo(x, 0);
        parent.da.window.scrollTo(0, 0);
      }
    }
  },
  __getMax: function (snbobj, lsnbobj) {
    if (snbobj && lsnbobj) {
      if (snbobj.offsetWidth > lsnbobj.offsetWidth) {
        return snbobj;
      } else {
        return lsnbobj;
      }
    } else {
      return false;
    }
  },
  __setLeft: function (obj) {
    if (obj) {
      var x = document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
      obj.style.left = docOverFlow.__addPx(x * -1);
    }
  },
  __setRight: function (obj) {
    if (obj) {
      var x = document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
      obj.style.right = docOverFlow.__addPx(x * -1);
    }
  },
  __addPx: function (obj) {
    return obj + 'px';
  },
  __getDivs: function () {
    docOverFlow.snbtabs = parent.snb.document.getElementById("snb_tabs");
    if (docOverFlow.snbtabs) {
      var snbdivs = docOverFlow.snbtabs.getElementsByTagName('div');
      for (var i = 0; i < snbdivs.length; i++) {
        docOverFlow.snbright = snbdivs[i];
        break;
      }
    }
    docOverFlow.lsnbtabs = parent.lsnb.document.getElementById("lsnb_menu");
    if (docOverFlow.lsnbtabs) {
      var lsnbdivs = docOverFlow.lsnbtabs.getElementsByTagName('div');
      for (var i = 0; i < lsnbdivs.length; i++) {
        docOverFlow.lsnbright = lsnbdivs[i];
        break;
      }
    }
  },
  __setEvents: function () {
    if (docOverFlow.snbtabs != null) {
      addEvent.add(window, "scroll", function () { docOverFlow.scroll() });
      addEvent.add(window, "resize", function () { docOverFlow.checkSize() });
    }
  }
};
//if prototype is loaded then add events with the library.
if (typeof document.observe == 'function') {
  document.observe("dom:loaded", function () {
    pageTitle.setTitle();
    docOverFlow.initialize();
    pullTab.changePullTab();
    Event.observe(window, "scroll", function () { pullTab.changePullTab(); });
    Event.observe(window, "resize", function () { pullTab.changePullTab(); });
    imageMap.initialize();
    tooltips.initialize();
  });
}
else {
  //Use the addevent model when prototype is not loaded.
  addEvent.add(window, "load", function () {
    pageTitle.setTitle();
    docOverFlow.initialize();
    pullTab.changePullTab();
    imageMap.initialize();
    tooltips.initialize();
  });
  addEvent.add(window, "scroll", function () { pullTab.changePullTab(); });
  addEvent.add(window, "resize", function () { pullTab.changePullTab(); });

}
 
 
 
 
 	


