﻿var origAlertHeight;
var origTotPadding;
var firstTimeClick = true;

function toggleAlert(mySpan, locAlert) {

    if (firstTimeClick) {
        origAlertHeight = $(locAlert).getStyle('height');
        origTotPadding = $(locAlert).getStyle('padding-top') + $(locAlert).getStyle('padding-bottom')
        firstTimeClick = false;
    }

    $(mySpan).toggleClassName('table_accordion_row_open');

    var arr = $(locAlert).childElements();
    arr.each(function (node) {
        if (!$(node).hasClassName('alertItemExpandItem')) {
            $(node).toggleClassName('hide');
        }
    });

    if ($(locAlert).getStyle('height') == origAlertHeight) {
        var conHeight = $(locAlert).getHeight() + 15;
        $(locAlert).setStyle({ height: conHeight + 'px' });
    } else {
        $(locAlert).setStyle({ height: origAlertHeight });
    }
}


var lastScrollWidth = 0;
var scrollWidth;
var first = true;

function setTableWidth(pages) {

    var tabWidth = $(pages).getWidth();
    var tabArray = $(pages).select('.tableTabPage');

    tabArray.each(function (node) {
        scrollWidth = tabWidth;
        if (first) {
            lastScrollWidth = scrollWidth;
            first = false;
        }
        $(node).setStyle({ width: tabWidth + 'px' });
        var containers = $(node).select('.container');
        $(containers[0]).setStyle({ width: tabWidth - 75 + 'px' });
    });
}

function toggleFilter(filter1, filter2) {
    $(filter1).toggleClassName('hide');
    $(filter2).toggleClassName('hide');
}

function toggleTableRow(mySpan, myRow, noPaging) {

    var endIndex = $(myRow).cells.length - 1;
    var startIndex = 1;

    if (noPaging) {
        endIndex = $(myRow).cells.length - 2;
        startIndex = 2;
    }


    $(mySpan).toggleClassName('table_accordion_row_open');
    for (var index = startIndex; index <= endIndex; index++) {

        var cell = $(myRow).cells[index];
        if (index == endIndex) {

            if ($(cell).colSpan == endIndex - 1) {
                $(cell).colSpan = 1;
            }
            else {
                if (noPaging)
                    $(cell).colSpan = endIndex - 1;                
                else
                    $(cell).colSpan = endIndex;
            }

            var arr = $(cell).childElements();
            arr.each(function (node) {
                $(node).toggleClassName('hide');

            });
        }
        else {
            $(cell).toggleClassName('hide');
        }
    }
}


function updatelTableTabPagination(buttons1, buttons2, tabContentId, pageCount, scrollWidth) {

    if ($(tabContentId)) {


        if ($(tabContentId).select('.tableTabPagesInner').size()) {

            var curPage = Math.round((-($(tabContentId).select('.tableTabPagesInner')[0].positionedOffset().left) / scrollWidth) + 1);

            $(buttons1).select('.sectionPaginationText')[0].select('span')[0].update(curPage);
            $(buttons2).select('.sectionPaginationText')[0].select('span')[0].update(curPage);

            if (curPage > 1) {
                $(buttons1).select('.sectionPaginationButtonLeft')[0].removeClassName('disabled');
                $(buttons2).select('.sectionPaginationButtonLeft')[0].removeClassName('disabled');
            } else {
                $(buttons1).select('.sectionPaginationButtonLeft')[0].addClassName('disabled');
                $(buttons2).select('.sectionPaginationButtonLeft')[0].addClassName('disabled');
            }

            if (curPage < pageCount) {
                $(buttons1).select('.sectionPaginationButtonRight')[0].removeClassName('disabled');
                $(buttons2).select('.sectionPaginationButtonRight')[0].removeClassName('disabled');
            } else {
                $(buttons1).select('.sectionPaginationButtonRight')[0].addClassName('disabled');
                $(buttons2).select('.sectionPaginationButtonRight')[0].addClassName('disabled');
            }

        }
    }
}

function resetTablePaginationWait(tabContentId) {

    setTimeout(function () { resetTablePagination(tabContentId); }, 500);
}

function resetTablePagination(tabContentId){
    var exitFunction = false;
    var currPage;

    var pageNumbers = tabContentId.select('.sectionPaginationText');
    pageNumbers.each(function (node) {
        currPage = node.select('span')[0].innerHTML;
        if (currPage == '1') {
            exitFunction = true;
            return;
        }
        node.select('span')[0].update('1');
    });

    if (exitFunction) {
        lastScrollWidth = scrollWidth;
        return;
    }

    var leftButtons = tabContentId.select('.sectionPaginationButtonLeft');
    leftButtons.each(function (node) {
        $(node).addClassName('disabled')
    });

    var rightButtons = tabContentId.select('.sectionPaginationButtonRight');
    rightButtons.each(function (node) {
        $(node).removeClassName('disabled')
    });

    //alert("last scroll width was:  " + lastScrollWidth);
    //alert("new scroll width is: " + scrollWidth);
    var intCurrPage = parseInt(currPage);
    //alert("current page is: " + intCurrPage);
    //alert("moved over : " + (intCurrPage - 1) * lastScrollWidth);

    var paginationScrollSpeed = 0.1;
    var updateVal = (intCurrPage - 1) * lastScrollWidth;
    

    new Effect.Move($(tabContentId).select('.tableTabPagesInner')[0], { duration: paginationScrollSpeed,
        transition: Effect.Transitions.sinoidal,
        x: updateVal,
        y: 0,
        mode: 'relative',
        afterFinish: '',
        queue: { scope: 'tablemove', limit: 1 }
    });

    lastScrollWidth = scrollWidth;
}
function scrollTableTabScroll(buttons1, buttons2, tabContentId, direction) {
    var paginationScrollSpeed = 0.4;

    if ($(tabContentId)) {

        if ($(tabContentId).select('.tableTabPagesInner').size()) {

            //var scrollWidth;
            pageCount = $(tabContentId).select('.tableTabPagesInner')[0].select('.tableTabPage').size();


            if (pageCount > 0) {
                scrollWidth = $(tabContentId).select('.tableTabPagesInner')[0].select('.tableTabPage')[0].getDimensions().width;
            } else {
                // default scroll width
                scrollWidth = 1400;
            }
            scrollWidth = scrollWidth;

            new Effect.Move($(tabContentId).select('.tableTabPagesInner')[0], { duration: paginationScrollSpeed,
                transition: Effect.Transitions.sinoidal,
                x: scrollWidth * direction,
                y: 0,
                mode: 'relative',
                afterFinish: function () { updatelTableTabPagination(buttons1, buttons2, tabContentId, pageCount, scrollWidth); },
                queue: { scope: 'tablemove', limit: 1 }
            });

        }

    }

}

function scrollTableTabRight(buttons1, buttons2, tabContentId) {

    if (!$(buttons1).select('.sectionPaginationButtonRight')[0].hasClassName('disabled')) {
        scrollTableTabScroll(buttons1, buttons2, tabContentId, -1);
        return;
    }

}

function scrollTableTabLeft(buttons1, buttons2, tabContentId) {

    if (!$(buttons1).select('.sectionPaginationButtonLeft')[0].hasClassName('disabled')) {
        scrollTableTabScroll(buttons1, buttons2,  tabContentId, 1);
    }
}






function updatelAlertTabPagination(buttons,tabContentId, pageCount, scrollWidth) {


    if ($(tabContentId)) {


        if ($(tabContentId).select('.alertTabPagesInner').size()) {

            var curPage = Math.round((-($(tabContentId).select('.alertTabPagesInner')[0].positionedOffset().left) / scrollWidth) + 1);

            $(buttons).select('.sectionPaginationText')[0].select('span')[0].update(curPage);

            if (curPage > 1) {
                $(buttons).select('.sectionPaginationButtonLeft')[0].removeClassName('disabled');
            } else {
                $(buttons).select('.sectionPaginationButtonLeft')[0].addClassName('disabled');
            }

            if (curPage < pageCount) {
                $(buttons).select('.sectionPaginationButtonRight')[0].removeClassName('disabled');
            } else {
                $(buttons).select('.sectionPaginationButtonRight')[0].addClassName('disabled');
            }

        }
    }
}

function scrollAlertTabScroll(buttons,tabContentId, direction) {

    var paginationScrollSpeed = 0.4;

    if ($(tabContentId)) {

        if ($(tabContentId).select('.alertTabPagesInner').size()) {

            var scrollWidth;
            pageCount = $(tabContentId).select('.alertTabPagesInner')[0].select('.alertTabPage').size();


            if (pageCount > 0) {
                scrollWidth = $(tabContentId).select('.alertTabPagesInner')[0].select('.alertTabPage')[0].getDimensions().width;
            } else {
                // default scroll width
                scrollWidth = 800;
            }
            scrollWidth = scrollWidth;

            new Effect.Move($(tabContentId).select('.alertTabPagesInner')[0], { duration: paginationScrollSpeed,
                transition: Effect.Transitions.sinoidal,
                x: scrollWidth * direction,
                y: 0,
                mode: 'relative',
                afterFinish: function () { updatelAlertTabPagination(buttons, tabContentId, pageCount, scrollWidth); },
                queue: { scope: 'alertmove', limit: 1 }
            });

        }

    }

}

function scrollAlertTabRight(buttons,tabContentId) {

    if (!$(buttons).select('.sectionPaginationButtonRight')[0].hasClassName('disabled')) {
        scrollAlertTabScroll(buttons, tabContentId, -1);
        return;
    }

}

function scrollAlertTabLeft(buttons, tabContentId) {
    
    if (!$(buttons).select('.sectionPaginationButtonLeft')[0].hasClassName('disabled')) {
        scrollAlertTabScroll(buttons,tabContentId, 1);
    }
}
